define([
		'app',
		'HealthMoodService',
		'HealthMoodConstants',
		'HealthMoodSummaryController',
		'HealthMoodEntryController',
        'AbstractHealthMoodService',
        'HealthMoodServiceConstants',
        'HealthMoodNavItemDateFilter',
        'HealthMoodNavController',
        'HealthMoodGraphService',
		'HealthMoodRemindersService',
		'HealthMoodRemindersInstanceService',
		'HealthMoodNotificationStatusController',
		'RemindersService',
		'NotificationDeliveryDirective',
		'MoodFeedbackService',
		'MoodFeedbackConstants'
	],
	function (app) {
		"use strict";

		app.config(function ($stateProvider) {
			$stateProvider
				.state('main.auth.two-panel.secondary-navigation.health-mood', {
					url: '/health-mood',
					appNavIndex: 7,
                    containerClass: 'health',
					data: {
						appletName: "Health",
                        moduleName: "Health",
                        icon : "learnmore-health",
						panel: "secondary",
                        baseStateName : 'main.auth.two-panel.secondary-navigation.health-mood',
                        initialState : "summary",
                        paramSections : [
                            {
                                paramValue : "bp-pulse",
                                sectionName : "Blood Pressure & Pulse",
                                sectionIndex : 1,
                                iconClass : "icon-health-bloodpressure",
                                templateUrl : "src/modules/health-mood/pages/nav/bp-pulse_item.html"
                            },
                            {
                                paramValue : "weight",
                                sectionName : "Weight",
                                sectionIndex : 2,
                                iconClass : "icon-health-weight",
                                templateUrl : "src/modules/health-mood/pages/nav/weight_item.html"
                            },
                            {
                                paramValue : "glucose",
                                sectionName : "Glucose",
                                sectionIndex : 3,
                                iconClass : "icon-health-glucose",
                                templateUrl : "src/modules/health-mood/pages/nav/glucose_item.html"
                            },
                            {
                                paramValue : "cholesterol",
                                sectionName : "Cholesterol",
                                sectionIndex : 4,
                                iconClass : "icon-health-cholesterol",
                                templateUrl : "src/modules/health-mood/pages/nav/cholesterol_item.html"
                            },
                            {
                                paramValue : "mood",
                                sectionName : "Mood",
                                sectionIndex : 5,
                                iconClass : "icon-mood-good",
                                templateUrl : "src/modules/health-mood/pages/nav/mood_item.html"
                            }
                        ]
					},
                    views : {
                        'primary@main.auth.two-panel': {
                            templateUrl: 'src/modules/health-mood/pages/health-placeholder_template.html',
                            controller: 'HealthMoodNavController'
                        }
                    }
				})
                .state('main.auth.two-panel.secondary-navigation.health-mood.summary', {
                    url: '/{section:bp-pulse|weight|glucose|cholesterol|mood}/summary',
                    data: {
                        panel : "primary",
                        backState : "^"
                    },
                    views : {
                        'primary@main.auth.two-panel': {
                            templateUrl: 'src/modules/health-mood/pages/summary/health-mood-summary_template.html',
                            controller: 'HealthMoodSummaryController'
                        }
                    }
                })
                .state('main.auth.two-panel.secondary-navigation.health-mood.entry', {
                    url: '/{section:bp-pulse|weight|glucose|cholesterol|mood}/entry?id',
                    data : {
                        panel : "primary",
                        backState : "^.summary"
                    },
                    views : {
                        'primary@main.auth.two-panel': {
                            templateUrl: 'src/modules/health-mood/pages/entry/health-mood-entry_template.html',
                            controller: 'HealthMoodEntryController'
                        }
                    }
                })
				.state('main.auth.two-panel.secondary-navigation.health-mood.notification', {
					url: '/{section:bp-pulse|weight|glucose|cholesterol|mood}/notification',
					data: {
						panel: 'primary',
						backState: '^.summary'
					},
					views: {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/health-mood/pages/notification-status/health-mood-notification-status_template.html',
							controller: 'HealthMoodNotificationStatusController'
						}
					}
				});
		});
	}
);
